<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaidaCaixa extends Model
{
    use HasFactory;

      // Nome da tabela
      protected $table='saidas_caixa';


    protected $fillable = [
        'referencia',
        'data',
        'descritivo',
        'observacao',
        'valor',
        'centros_custo_id',
        'users_id',
        'recebido_por',
        'assinatura',
        'suporte_documental',
        'status',
    ];

    

    public function centroCusto()
    {
        return $this->belongsTo(CentroCusto::class, 'centros_custo_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'users_id');
    }
}
