<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreSaidaCaixaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */

     // Cria regras de validação para o formulario de saida de caixa
    public function rules(): array
    {
        return [
            'referencia' => 'required|string|max:50',
            'data' => 'required|date',
            'descritivo' => 'required|string|max:255',
            'observacao' => 'nullable|string|max:255',
            'valor' => 'required|numeric',
            'centros_custo_id' => 'required|exists:centros_custo,id',
            'users_id' => 'required|exists:users,id',
            'recebido_por' => 'required|string|max:50',
        ];
    }

    //Mensagenns personalizadas para as regras de validação dos campos
    public function messages(): array
    {
        return[
            'referencia.required'=>'Campo referência é de preenchemento obrigatório',
            'data.required'=>'Campo data é de preenchemento obrigatório',
            'data.date'=>'Necessário enviar data válida',
            'valor.numeric'=>'Necessário enviar valor numérico',
            'observacao.max'=>'Campo observação deve ter no máximo 255 caracteres',
            'descritivo.max'=>'Campo descritivo deve ter no máximo 255 caracteres',
            'descritivo.required'=>'Campo descritivo é de preenchemento obrigatório',
            'valor.required'=>'Campo valor é de preenchemento obrigatório',
            'centros_custo_id.required'=>'Campo centro de custo é de preenchemento obrigatório',
            'users_id.required'=>'Campo utilizador é de preenchemento obrigatório',
            'recebido_por.required'=>'Campo recebido por é de preenchemento obrigatório',
           
        ];

    }
}
