<!-- Edit User Modal -->
<div class="modal fade exampleModalFullscreen1" tabindex="-1" aria-labelledby="exampleModalFullscreenLabel1" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #47b666">
                <h5 class="modal-title" id="exampleModalFullscreenLabel1">EDITAR UTILIZADOR</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
                <form class="row g-3" id="editUserForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <!-- Dados Pessoais -->
                    <div class="col-md-12">
                        <h4>Dados Pessoais</h4>
                        <hr>
                    </div>

                    <div class="col-md-6">
                        <label for="edit_name" class="form-label">Nome Completo</label>
                        <input type="text" class="form-control" id="edit_name" name="name" required>
                    </div>

                    <div class="col-md-3">
                        <label for="edit_nID" class="form-label">Número de Identificação</label>
                        <input type="text" class="form-control" id="edit_nID" name="nID" required>
                    </div>

                    <div class="col-md-3">
                        <label for="edit_tipoID" class="form-label">Tipo de Documento</label>
                        <select class="form-select" id="edit_tipoID" name="tipoID" required>
                            <option value="" disabled>Escolha...</option>
                            <option value="BI">BI</option>
                            <option value="Passaporte">Passaporte</option>
                            <option value="Outro">Outro</option>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="edit_genero" class="form-label">Género</label>
                        <select class="form-select" id="edit_genero" name="genero" required>
                            <option value="" disabled>Escolha...</option>
                            <option value="Masculino">Masculino</option>
                            <option value="Feminino">Feminino</option>
                            <option value="Outro">Outro</option>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="edit_dataNasc" class="form-label">Data de Nascimento</label>
                        <input type="date" class="form-control" id="edit_dataNasc" name="dataNasc" required>
                    </div>

                    <div class="col-md-3">
                        <label for="edit_telefone" class="form-label">Telefone</label>
                        <input type="text" class="form-control" id="edit_telefone" name="telefone" required>
                    </div>

                    <div class="col-md-3">
                        <label for="edit_contactoPrimario" class="form-label">Contacto Primário</label>
                        <input type="text" class="form-control" id="edit_contactoPrimario" name="contactoPrimario" required>
                    </div>

                    <div class="col-md-12">
                        <label for="edit_status" class="form-label">Status</label>
                        <select class="form-select" id="edit_status" name="status">
                            <option value="on">Ativo</option>
                            <option value="off">Inativo</option>
                        </select>
                    </div>

                    <div class="col-md-12">
                        <label for="edit_obs" class="form-label">Observações</label>
                        <textarea class="form-control" id="edit_obs" name="obs" rows="3"></textarea>
                    </div>

                    <!-- Dados de Acesso -->
                    <div class="col-md-12">
                        <h4>Dados de Acesso</h4>
                        <hr>
                    </div>

                    <div class="col-md-4">
                        <label for="edit_email" class="form-label">E-mail</label>
                        <input type="email" class="form-control" id="edit_email" name="email" required>
                    </div>

                    <div class="col-md-4">
                        <label for="edit_password" class="form-label">Nova Senha (deixe em branco para manter a atual)</label>
                        <input type="password" class="form-control" id="edit_password" name="password">
                    </div>

                    <div class="col-md-4">
                        <label for="edit_password_confirmation" class="form-label">Confirmar Nova Senha</label>
                        <input type="password" class="form-control" id="edit_password_confirmation" name="password_confirmation">
                    </div>

                    <div class="col-md-4">
                        <label for="edit_tipoConta" class="form-label">Tipo de Conta</label>
                        <select class="form-select" id="edit_tipoConta" name="tipoConta" required>
                            <option value="" disabled>Escolha...</option>
                            <option value="Administrador">Administrador</option>
                            <option value="Operador">Operador</option>
                            <option value="Cliente">Cliente</option>
                        </select>
                    </div>

                    <div class="col-md-8">
                        <label class="form-label">Permissões</label>
                        <div class="d-flex gap-3 mt-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="edit_admin" name="admin">
                                <label class="form-check-label" for="edit_admin">
                                    Administrador
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="edit_client" name="client">
                                <label class="form-check-label" for="edit_client">
                                    Cliente
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-12 text-end">
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-success">Atualizar Utilizador</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Capturar o evento de exibição do modal para buscar os dados do utilizador
        $('.exampleModalFullscreen1').on('show.bs.modal', function (event) {
            const button = $(event.relatedTarget);
            const userId = button.data('id');
            const form = document.getElementById('editUserForm');
            
            // Define a rota de submissão do formulário
            form.action = `/users/${userId}`;
            
            // Buscar os dados do utilizador
            fetch(`/users/${userId}`)
                .then(response => response.json())
                .then(data => {
                    // Preencher os campos com os dados do utilizador
                    document.getElementById('edit_name').value = data.name;
                    document.getElementById('edit_email').value = data.email;
                    document.getElementById('edit_nID').value = data.pessoa.nID;
                    document.getElementById('edit_tipoID').value = data.pessoa.tipoID;
                    document.getElementById('edit_genero').value = data.pessoa.genero;
                    document.getElementById('edit_dataNasc').value = data.pessoa.dataNasc;
                    document.getElementById('edit_telefone').value = data.pessoa.telefone;
                    document.getElementById('edit_contactoPrimario').value = data.pessoa.contactoPrimario;
                    document.getElementById('edit_status').value = data.pessoa.status;
                    document.getElementById('edit_tipoConta').value = data.pessoa.tipoConta;
                    document.getElementById('edit_obs').value = data.pessoa.obs || '';
                    
                    // Configurar os checkboxes de permissões
                    document.getElementById('edit_admin').checked = data.admin;
                    document.getElementById('edit_client').checked = data.client;
                })
                .catch(error => {
                    console.error('Error fetching user data:', error);
                    Swal.fire({
                        title: 'Erro',
                        text: 'Ocorreu um erro ao carregar os dados do utilizador.',
                        icon: 'error'
                    });
                });
        });

        // Sincronizar o tipo de conta com as permissões de checkbox
        const tipoContaSelect = document.getElementById('edit_tipoConta');
        const adminCheckbox = document.getElementById('edit_admin');
        const clientCheckbox = document.getElementById('edit_client');

        tipoContaSelect.addEventListener('change', function() {
            const selectedValue = this.value;
            
            // Reset checkboxes
            adminCheckbox.checked = false;
            clientCheckbox.checked = false;
            
            // Set appropriate checkbox based on selection
            if (selectedValue === 'Administrador') {
                adminCheckbox.checked = true;
            } else if (selectedValue === 'Cliente') {
                clientCheckbox.checked = true;
            }
        });
    });
</script>
<?php /**PATH /mnt/home1/giscardt/servluandapa/petrosys/resources/views/Administracao/ComponentesAdmin/Users/Cpt_EditUser.blade.php ENDPATH**/ ?>