<!-- Modal de Visualização de Comprovativo de Pagamento -->
<div class="modal fade" id="modalVisualizar" tabindex="-1" aria-labelledby="modalVisualizarLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalVisualizarLabel">Detalhes do Comprovativo de Pagamento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12 mb-4 text-center">
                        <h6 class="text-muted mb-2">Comprovativo</h6>
                        <div id="preview-container" class="embed-responsive embed-responsive-16by9">
                            <iframe id="doc-preview" class="embed-responsive-item" style="width: 100%; height: 400px;" src="" frameborder="0"></iframe>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Data e Hora do Pagamento</h6>
                        <p id="view-data-hora"></p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Status</h6>
                        <p id="view-status"></p>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Banco de Origem</h6>
                        <p id="view-banco-origem"></p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Banco de Destino</h6>
                        <p id="view-banco-destino"></p>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Funcionário</h6>
                        <p id="view-funcionario"></p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Validado por</h6>
                        <p id="view-validador"></p>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Data de Validação</h6>
                        <p id="view-data-validacao"></p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-muted mb-2">Observação</h6>
                        <p id="view-observacao"></p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Configura o modal de visualização
    var modalVisualizar = document.getElementById('modalVisualizar');
    modalVisualizar.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var id = button.getAttribute('data-id');
        
        // Faz requisição AJAX para obter os detalhes do comprovativo
        fetch('/petrosys/public/comprovativos/' + id)
            .then(response => response.json())
            .then(data => {
                // Atualiza o iframe com o documento
                document.getElementById('doc-preview').src = '/petrosys/public/Doc/ComprovativosPagamento/' + data.arquivo_comprovativo;
                
                // Formata e exibe a data e hora
                const dataHora = new Date(data.data_hora);
                document.getElementById('view-data-hora').textContent = dataHora.toLocaleString('pt-PT');
                
                // Exibe o status com classe de cor
                let statusHtml = '';
                if (data.status === 'pendente') {
                    statusHtml = '<span class="badge bg-warning">Pendente</span>';
                } else if (data.status === 'validado') {
                    statusHtml = '<span class="badge bg-success">Validado</span>';
                } else {
                    statusHtml = '<span class="badge bg-danger">Invalidado</span>';
                }
                document.getElementById('view-status').innerHTML = statusHtml;
                
                // Exibe os dados dos bancos
                document.getElementById('view-banco-origem').textContent = data.banco_origem?.nome || 'N/A';
                document.getElementById('view-banco-destino').textContent = data.banco_destino?.nome || 'N/A';
                
                // Exibe os dados do funcionário e validador
                document.getElementById('view-funcionario').textContent = data.user?.name || 'N/A';
                document.getElementById('view-validador').textContent = data.validador?.name || 'N/A';
                
                // Formata e exibe a data de validação
                if (data.data_validacao) {
                    const dataValidacao = new Date(data.data_validacao);
                    document.getElementById('view-data-validacao').textContent = dataValidacao.toLocaleString('pt-PT');
                } else {
                    document.getElementById('view-data-validacao').textContent = 'N/A';
                }
                
                // Exibe a observação
                document.getElementById('view-observacao').textContent = data.observacao || 'N/A';
            })
            .catch(error => {
                console.error('Erro ao carregar dados:', error);
                Swal.fire('Erro', 'Não foi possível carregar os detalhes do comprovativo', 'error');
            });
    });
});
</script>
<?php /**PATH /mnt/home1/giscardt/servluandapa/petrosys/resources/views/Administracao/ComponentesAdmin/ComprovativosPagamento/Cpt_Visualizar.blade.php ENDPATH**/ ?>