<!-- Modal de Busca Parametrizada para Comprovativos de Pagamento -->
<div class="modal fade" id="modalBuscaParametrizada" tabindex="-1" aria-labelledby="modalBuscaParametrizadaLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalBuscaParametrizadaLabel">Busca Parametrizada</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('comprovativos.search')); ?>" method="GET">
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="start_date" class="form-label">Data Inicial</label>
                            <input type="date" class="form-control" id="start_date" name="start_date">
                        </div>
                        <div class="col-md-6">
                            <label for="end_date" class="form-label">Data Final</label>
                            <input type="date" class="form-control" id="end_date" name="end_date">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="banco_origem" class="form-label">Banco de Origem</label>
                            <select class="form-select" id="banco_origem" name="banco_origem">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($banco->id); ?>"><?php echo e($banco->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="banco_destino" class="form-label">Banco de Destino</label>
                            <select class="form-select" id="banco_destino" name="banco_destino">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($banco->id); ?>"><?php echo e($banco->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="funcionario" class="form-label">Funcionário</label>
                            <select class="form-select" id="funcionario" name="funcionario">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" id="status" name="status">
                                <option value="">Todos</option>
                                <option value="pendente">Pendente</option>
                                <option value="validado">Validado</option>
                                <option value="invalidado">Invalidado</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="reset" class="btn btn-warning">Limpar Filtros</button>
                    <button type="submit" class="btn btn-primary">Pesquisar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH /mnt/home1/giscardt/servluandapa/petrosys/resources/views/Administracao/ComponentesAdmin/ComprovativosPagamento/Cpt_BuscaParametrizada.blade.php ENDPATH**/ ?>