<!-- Modal de Cadastro de Comprovativo de Pagamento -->
<div class="modal fade" id="modalCadastro" tabindex="-1" aria-labelledby="modalCadastroLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalCadastroLabel">Novo Comprovativo de Pagamento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('comprovativos.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="arquivo_comprovativo" class="form-label">Arquivo de Comprovativo *</label>
                            <input type="file" class="form-control" id="arquivo_comprovativo" name="arquivo_comprovativo" required accept=".pdf,.jpg,.jpeg,.png">
                            <small class="text-muted">Formatos aceitos: PDF, JPG, JPEG, PNG (máx. 2MB)</small>
                        </div>
                        <div class="col-md-6">
                            <label for="data_hora" class="form-label">Data e Hora do Pagamento *</label>
                            <input type="datetime-local" class="form-control" id="data_hora" name="data_hora" required>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="banco_origem_id" class="form-label">Banco de Origem *</label>
                            <select class="form-select" id="banco_origem_id" name="banco_origem_id" required>
                                <option value="">Selecione um banco</option>
                                <?php $__currentLoopData = $bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($banco->id); ?>"><?php echo e($banco->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="banco_destino_id" class="form-label">Banco de Destino *</label>
                            <select class="form-select" id="banco_destino_id" name="banco_destino_id" required>
                                <option value="">Selecione um banco</option>
                                <?php $__currentLoopData = $bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($banco->id); ?>"><?php echo e($banco->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="users_id" class="form-label">Funcionário que Acompanhou o Pagamento *</label>
                            <select class="form-select" id="users_id" name="users_id" required>
                                <option value="">Selecione um funcionário</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="observacao" class="form-label">Observação</label>
                            <textarea class="form-control" id="observacao" name="observacao" rows="3"></textarea>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <p class="text-muted mb-0"><small>* Campos obrigatórios</small></p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH /mnt/home1/giscardt/servluandapa/petrosys/resources/views/Administracao/ComponentesAdmin/ComprovativosPagamento/Cpt_Cadastro.blade.php ENDPATH**/ ?>