<!-- Modal de Validação/Invalidação de Comprovativo de Pagamento -->
<div class="modal fade" id="modalValidar" tabindex="-1" aria-labelledby="modalValidarLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalValidarLabel">Validar/Invalidar Comprovativo</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="form-validar" action="" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="row mb-4">
                        <div class="col-md-12 text-center">
                            <div class="mb-3">
                                <a id="validar-link-doc" href="" target="_blank" class="btn btn-sm btn-primary">
                                    <i class="ri-file-line me-1"></i>Visualizar Comprovativo
                                </a>
                            </div>
                            <div class="btn-group" role="group" aria-label="Status do comprovativo">
                                <input type="radio" class="btn-check" name="status" id="status-validado" value="validado" autocomplete="off" checked>
                                <label class="btn btn-outline-success" for="status-validado">Validar</label>
                                
                                <input type="radio" class="btn-check" name="status" id="status-invalidado" value="invalidado" autocomplete="off">
                                <label class="btn btn-outline-danger" for="status-invalidado">Invalidar</label>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="validar-observacao" class="form-label">Observação/Justificação</label>
                            <textarea class="form-control" id="validar-observacao" name="observacao" rows="3"></textarea>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <i class="ri-information-line me-1"></i>
                                <small>Ao validar ou invalidar um comprovativo, você estará associando seu utilizador como o responsável por esta ação.</small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary" id="btn-confirmar-validacao">Confirmar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Configura o modal de validação
    var modalValidar = document.getElementById('modalValidar');
    modalValidar.addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var id = button.getAttribute('data-id');
        
        // Define a ação do formulário
        document.getElementById('form-validar').action = `/petrosys/public/comprovativos/${id}/validar`;
        
        // Faz requisição AJAX para obter os detalhes do comprovativo
        fetch(`/petrosys/public/comprovativos/${id}`)
            .then(response => response.json())
            .then(data => {
                // Configura o link para o documento
                document.getElementById('validar-link-doc').href = `/petrosys/public/Doc/ComprovativosPagamento/${data.arquivo_comprovativo}`;
                
                // Pré-seleciona o status atual (se já estiver validado ou invalidado)
                if (data.status === 'validado') {
                    document.getElementById('status-validado').checked = true;
                } else if (data.status === 'invalidado') {
                    document.getElementById('status-invalidado').checked = true;
                }
                
                // Preenche a observação atual
                document.getElementById('validar-observacao').value = data.observacao || '';
                
                // Altera o texto do botão conforme o status selecionado
                atualizarBotaoValidacao();
            })
            .catch(error => {
                console.error('Erro ao carregar dados:', error);
                Swal.fire('Erro', 'Não foi possível carregar os detalhes do comprovativo', 'error');
            });
    });
    
    // Atualiza o texto do botão conforme a seleção de status
    function atualizarBotaoValidacao() {
        const botao = document.getElementById('btn-confirmar-validacao');
        const statusValidado = document.getElementById('status-validado').checked;
        
        if (statusValidado) {
            botao.textContent = 'Confirmar Validação';
            botao.className = 'btn btn-success';
        } else {
            botao.textContent = 'Confirmar Invalidação';
            botao.className = 'btn btn-danger';
        }
    }
    
    // Adiciona evento para os botões de rádio de status
    document.getElementById('status-validado').addEventListener('change', atualizarBotaoValidacao);
    document.getElementById('status-invalidado').addEventListener('change', atualizarBotaoValidacao);
});
</script>
