<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('comprovativos_pagamento', function (Blueprint $table) {
            $table->id();
            $table->string('arquivo_comprovativo', 255);
            $table->datetime('data_hora');
            $table->foreignId('banco_origem_id')->constrained('bancos')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('banco_destino_id')->constrained('bancos')->onDelete('cascade')->onUpdate('cascade');
            $table->foreignId('users_id')->constrained('users')->onDelete('cascade')->onUpdate('cascade');
            $table->text('observacao')->nullable();
            $table->string('status', 20)->default('pendente'); // pendente, validado, invalidado
            $table->foreignId('validado_por')->nullable()->constrained('users')->onDelete('set null')->onUpdate('cascade');
            $table->datetime('data_validacao')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('comprovativos_pagamento');
    }
};
