<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ComprovativoPagamento extends Model
{
    use HasFactory;

    // Nome da tabela
    protected $table = 'comprovativos_pagamento';

    protected $fillable = [
        'arquivo_comprovativo',
        'data_hora',
        'banco_origem_id',
        'banco_destino_id',
        'users_id',
        'observacao',
        'status',
        'validado_por',
        'data_validacao'
    ];

    // Relacionamento com o modelo Banco (Origem)
    public function bancoOrigem()
    {
        return $this->belongsTo(Banco::class, 'banco_origem_id');
    }

    // Relacionamento com o modelo Banco (Destino)
    public function bancoDestino()
    {
        return $this->belongsTo(Banco::class, 'banco_destino_id');
    }

    // Relacionamento com o modelo User (Funcionário)
    public function user()
    {
        return $this->belongsTo(User::class, 'users_id');
    }

    // Relacionamento com o modelo User (Validador)
    public function validador()
    {
        return $this->belongsTo(User::class, 'validado_por');
    }
}
