<?php

namespace App\Http\Controllers;

use App\Http\Requests\LoginRequest;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AcessoController extends Controller
{
    public function index(){

        Auth::logout();

        return view('Seguranca/auth-sigin');
    }


    //Validar os dados do usuário no login
    public function loginProcess(LoginRequest $request){

        //Validar o formulário de Logi
        
        $request->validated();

        //validar o usuario e a senha com as informaçõa da BD

        $Authenticated = Auth::attempt(['email'=>$request->username,'password'=>$request->password]);

        //Verificar se o USER foi autenticado

        if(!$Authenticated){
            return back()->withInput()->with('error','Utilizaddor ou Palavra-passe inválidos....');
        }


        $nivel=User::where('email',$request->username)->first();

       if($nivel->admin){

        return redirect()->route('home');

       }
       return redirect()->route('homeCliente');

       


    
    }

    public function logoutProcess(){

        
        //validar o usuario e a senha com as informaçõa da BD

        Auth::logout();

        return redirect()->route('login');


    
    }
}
